#ifndef _HOST_COMM_H_
#define _HOST_COMM_H_

#define CSG550_COMMAND_SIZE             1
#define MAX_CSG550_MSG_BODY_SIZE        4
#define TX_MASSAGE_LEN                  4

enum sdk_commands_e
{
    HOST_CMD_GET_METER_CONFIGURATION            = 0x56,
    HOST_CMD_SET_METER_CONSUMPTION              = 0x57,
    HOST_CMD_SET_RTC                            = 0x58,
    HOST_CMD_GET_RTC                            = 0x59,
    HOST_CMD_SET_PASSWORD                       = 0x60,
    HOST_CMD_GET_READINGS_PHASE_1               = 0x61,
    HOST_CMD_GET_READINGS_PHASE_2               = 0x62,
    HOST_CMD_GET_READINGS_PHASE_3               = 0x63,
    HOST_CMD_GET_READINGS_NEUTRAL               = 0x64,
    HOST_CMD_ERASE_FLASH_SEGMENT                = 0x70,
    HOST_CMD_SET_FLASH_POINTER                  = 0x71,
    HOST_CMD_FLASH_DOWNLOAD                     = 0x72,
    HOST_CMD_FLASH_UPLOAD                       = 0x73,
    HOST_CMD_ZAP_MEMORY_AREA                    = 0x74,
    HOST_CMD_SUMCHECK_MEMORY                    = 0x75,
    HOST_CMD_GET_RAW_POWER_PHASE_1              = 0x91,
    HOST_CMD_GET_RAW_POWER_PHASE_2              = 0x92,
    HOST_CMD_GET_RAW_POWER_PHASE_3              = 0x93,
    HOST_CMD_GET_RAW_REACTIVE_POWER_PHASE_1     = 0x95,
    HOST_CMD_GET_RAW_REACTIVE_POWER_PHASE_2     = 0x96,
    HOST_CMD_GET_RAW_REACTIVE_POWER_PHASE_3     = 0x97,
    HOST_CMD_GET_RAW_POWER_NEUTRAL              = 0x94,//0x99,  Percy
    HOST_CMD_GET_RAW_REACTIVE_POWER_NEUTRAL     = 0x98,//0x9D,
    HOST_CMD_CHECK_RTC_ERROR                    = 0xA0,
    HOST_CMD_RTC_CORRECTION                     = 0xA1,
    HOST_CMD_MULTIRATE_SET_PARAMETERS           = 0xC0,
    HOST_CMD_MULTIRATE_GET_PARAMETERS           = 0xC1,
    HOST_CMD_MULTIRATE_CLEAR_USAGE              = 0xC2,
    HOST_CMD_MULTIRATE_GET_USAGE                = 0xC3,
    HOST_CMD_CALIBRATION_GET_GAIN               = 0xE0,         
    HOST_CMD_CALIBRATION_GET_CONF               = 0xE1,        
    HOST_CMD_CALIBRATION_SET_GAIN               = 0xE2,         
    HOST_CMD_CALIBRATION_SET_PHASE              = 0xE3,
    HOST_CMD_CALIBRATION_STORE                  = 0xE4,
    HOST_CMD_CALIBRATION_SET_IRMS_GAIN          = 0xE5,         
    HOST_CMD_CALIBRATION_SET_VRMS_GAIN          = 0xE6,         
    HOST_CMD_CALIBRATION_SET_POFFSET            = 0xE7,
    HOST_CMD_CALIBRATION_SET_QOFFSET            = 0xE8,
    HOST_CMD_CALIBRATION_SET_IRMS_OFFSET        = 0xE9,
    HOST_CMD_CONFIG_SET_SYSCONF                 = 0xEA,         
    HOST_CMD_CONFIG_SET_CSGCONF                 = 0xEB,
    HOST_CMD_CONFIG_SET_PCONST                  = 0xEC,
    HOST_CMD_CONFIG_SET_STARTCUR                = 0xED,   
    HOST_CMD_CONFIG_SET_IE                      = 0xEE,   
    HOST_CMD_CONFIG_SET_WREN                    = 0xEF,   
    HOST_CMD_CONFIG_SET_SRST                    = 0xF0,       
};

#define MAX_IEC1107_MSG_BODY        64
typedef union
{
    unsigned char uint8[4 + 12 + MAX_IEC1107_MSG_BODY];
    unsigned int uint16[(4 + 12 + MAX_IEC1107_MSG_BODY)/2];
} serial_msg_t;

#define IEC1107_MSG_RX_START_BODY   10
#define IEC1107_MSG_RX_START_BODY_W 5
#define IEC1107_MSG_TX_START_BODY   14
#define IEC1107_MSG_TX_START_BODY_W 7

///////////////////////////////////////////////////////////////////////////////////////
extern serial_msg_t rx_msg;
extern unsigned char rx_msg_len;
extern uint16_t char_timeout_1107;
extern unsigned char rx_msg_ptr;

/* Outgoing serial message buffer */
extern serial_msg_t tx_msg;
extern unsigned char tx_msg_len;
extern unsigned char tx_msg_ptr;

/////////////////////////////////////////////////////////////////////
int send_msg(int len);
int prepare_tx_message(int len);
void process_rx_message(serial_msg_t *rx_msg, int rx_len);
void send_calibration_data();
void send_config_data();
void send_AFE_reading(unsigned char ch);

#endif

